/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.esl.fabric.util;

import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import org.antarcticgardens.esl.fabric.transaction.FabricTransaction;
import org.antarcticgardens.esl.transaction.TransactionUtil;
import org.antarcticgardens.esl.util.ItemHolder;
import org.antarcticgardens.esl.util.Mth;

public class ContextItemHolder
implements ItemHolder {
    private final ContainerItemContext context;

    public ContextItemHolder(ContainerItemContext context) {
        this.context = context;
    }

    @Override
    public class_1792 getItem() {
        return this.context.getItemVariant().getItem();
    }

    @Override
    public long getAmount() {
        return this.context.getAmount();
    }

    @Override
    public class_2487 getNbt() {
        return this.context.getItemVariant().getNbt();
    }

    @Override
    public void setItem(class_1792 item) {
        this.setVariant(ItemVariant.of((class_1935)item, (class_2487)this.getNbt()));
    }

    @Override
    public void setAmount(long amount) {
        try (FabricTransaction t = (FabricTransaction)TransactionUtil.openOuterOrNested();){
            if (this.context.getAmount() > amount) {
                this.context.extract(this.context.getItemVariant(), this.context.getAmount() - amount, (TransactionContext)t.getHandle());
            } else if (this.context.getAmount() < amount) {
                this.context.insert(this.context.getItemVariant(), amount - this.context.getAmount(), (TransactionContext)t.getHandle());
            }
        }
    }

    @Override
    public void setNbt(class_2487 nbt) {
        this.setVariant(ItemVariant.of((class_1935)this.getItem(), (class_2487)nbt));
    }

    public void setVariant(ItemVariant variant) {
        try (FabricTransaction t = (FabricTransaction)TransactionUtil.openOuterOrNested();){
            this.context.exchange(variant, this.context.getAmount(), (TransactionContext)t.getHandle());
            t.commit();
        }
    }

    @Override
    public void fromItemStack(class_1799 stack) {
        this.setVariant(ItemVariant.of((class_1799)stack));
        this.setAmount(stack.method_7947());
    }

    @Override
    public class_1799 toItemStack() {
        return this.context.getItemVariant().toStack(Mth.longToIntSaturated(this.getAmount()));
    }
}

